#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

__kernel void MAIN(
      __read_only image2d_t input1,
	  __read_only image2d_t input2,
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha)
{	

	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	vec4 orig = INPUTSRC(input1, param, tc);
     
    vec4 texel = (vec4)(
                  INPUT(input2, param, (vec2)(orig.x,.16666f)).x,
                  INPUT(input2, param, (vec2)(orig.y,.5f)).y,
                  INPUT(input2, param, (vec2)(orig.z,.83333f)).z,
				  orig.w);
	
	vec4 outColor = mix(texel, orig, (float4)(1.0f - (float)alpha/100.0f));
	//outColor = (vec4)( INPUT(input2, param, (vec2)(orig.x, .16666f)).x );
    write_imagef(dest_data, gl_FragCoord, outColor);
}


    